/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "RpcRemoteException.h"

#include <msgpack.hpp>
#include <sstream>
#include <string>

namespace msgpack
{
	MSGPACK_API_VERSION_NAMESPACE(MSGPACK_DEFAULT_API_NS)
	{
		namespace adaptor
		{
			template<> struct convert<RpcRemoteException>
			{
				const msgpack::object& operator()(const msgpack::object& o, RpcRemoteException& v) const
				{
					if (o.type != msgpack::type::ARRAY)
						throw msgpack::type_error();
					if (o.via.array.size < 3)
						throw msgpack::type_error();

					std::stringstream message;
					message << o.via.array.ptr[0].as<std::string>() << std::endl;

					msgpack::object inner = o.via.array.ptr[o.via.array.size - 1];
					while (!inner.is_nil())
					{
						if (inner.type != msgpack::type::ARRAY)
							throw msgpack::type_error();
						if (inner.via.array.size < 3)
							throw msgpack::type_error();

						message << inner.via.array.ptr[0].as<std::string>() << ": " << inner.via.array.ptr[1].as<std::string>() << std::endl;
						inner = inner.via.array.ptr[inner.via.array.size - 1];
					}

					if (!o.via.array.ptr[1].is_nil())
						v = RpcRemoteException(message.str(), o.via.array.ptr[1].as<std::string>());
					else
						v = RpcRemoteException(message.str());

					return o;
				}
			};

			template<> struct pack<RpcRemoteException>
			{
				template<typename Stream> msgpack::packer<Stream>& operator()(msgpack::packer<Stream>&, const RpcRemoteException&) const
				{
					throw std::runtime_error("Not supported!");
				}
			};
		} // namespace adaptor
	} // MSGPACK_API_VERSION_NAMESPACE(MSGPACK_DEFAULT_API_NS)
} // namespace msgpack
